﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static prj_wfrm_centreCall_tickets.tab;

namespace prj_wfrm_centreCall_tickets
{
    public partial class frmTechnicienAfficherParTauxHoraire : Form
    {
        public frmTechnicienAfficherParTauxHoraire()
        {
            InitializeComponent();
        }

        private void frmTechnicienAfficherParTauxHoraire_Load(object sender, EventArgs e)
        {

        }

        private void btn_valider_Click(object sender, EventArgs e)
        {
			lvTecTauxHoraire.Items.Clear();
			//On utilise try pour vérifier que la valeur entrée est bien une valeur numérique, sinon, les valeurs entrées sont obligatoirement non valides
			//Car le programme va s'arrêter si on essaie de convertir du string en double
			try
			{
				double tauxMin = Convert.ToDouble(tb_tauxMin.Text);
				double tauxMax = Convert.ToDouble(tb_tauxMax.Text);

				//On sait que les valeurs entrées sont des nombres, il ne reste plus qu'à vérifier leur validité
				if (tauxMax < tauxMin || tauxMax < 0 || tauxMin < 0)
				{
					MessageBox.Show("Les taux entrés ne sont pas valides.");
				}
				else 
				{
					//Dans ce cas, il n'y a pas de problèmes dans la saisie des taux horaires minimum et maximum
					//Il faut donc maintenant afficher les techniciens concernés par l'intervalle dans la ListView

					//Pour cela, on parcours tous le tableau des techniciens
					//Pour chaque technicien, s'il appartient à l'intervalle voulu, on ajoute ses informations dans la ListView
					for (int i = 0; i < tab.nbTechniciens; i++)
					{
						if (tab.technicien[i].tauxHoraire >= tauxMin && tab.technicien[i].tauxHoraire <= tauxMax)
						{
							//configuration d'une ligne de la liste
							ListViewItem ligne = new ListViewItem();
							//1ère colonne = numéro du technicien
							ligne.Text = tab.technicien[i].numero.ToString();
							//2ème colonne = nom du technicien
							ligne.SubItems.Add(tab.technicien[i].nomTech);
							//3ème colonne = Prénom du technicien
							ligne.SubItems.Add(tab.technicien[i].prenomTech);

							//ajout de la ligne dans la liste
							lvTecTauxHoraire.Items.Add(ligne);
						}
					}
				}
			}
			catch
			{
				MessageBox.Show("Vous devez entrer des valeurs numériques");
			}
            

        }
    }
}
